/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.crydolph.entities.goals;

import de.cadentem.crydolph.entities.CrydolphEntity;
import de.cadentem.crydolph.entities.goals.Roll;
import de.cadentem.crydolph.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CrydolphStareGoal
extends Goal {
    private final CrydolphEntity cryDolph;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public CrydolphStareGoal(CrydolphEntity cryDolph) {
        this.cryDolph = cryDolph;
        this.lookedAtMax = cryDolph.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.cryDolph.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.cryDolph.m_5448_())) {
            return false;
        }
        return this.cryDolph.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.cryDolph.m_5448_())) {
            return false;
        }
        return this.cryDolph.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.cryDolph.pleaseStopMoving = false;
        this.cryDolph.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.cryDolph.m_5448_();
        if (target == null) {
            this.cryDolph.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.cryDolph.targetIsFacingMe && target.m_142582_((Entity)this.cryDolph);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.cryDolph.m_217043_().m_188500_() < 0.1) {
                this.cryDolph.disappear();
            } else if (this.cryDolph.m_217043_().m_188500_() < 0.3) {
                this.cryDolph.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.cryDolph.pleaseStopMoving = false;
            this.cryDolph.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.cryDolph.pleaseStopMoving = true;
            this.cryDolph.m_21573_().m_26573_();
            this.cryDolph.m_20256_(Vec3.f_82478_);
        }
        this.cryDolph.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

