/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.yeti.entities.goals;

import de.cadentem.yeti.entities.YetiEntity;
import de.cadentem.yeti.entities.goals.Roll;
import de.cadentem.yeti.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class YetiStareGoal
extends Goal {
    private final YetiEntity theYeti;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public YetiStareGoal(YetiEntity theYeti) {
        this.theYeti = theYeti;
        this.lookedAtMax = theYeti.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.theYeti.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.theYeti.m_5448_())) {
            return false;
        }
        return this.theYeti.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.theYeti.m_5448_())) {
            return false;
        }
        return this.theYeti.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.theYeti.pleaseStopMoving = false;
        this.theYeti.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.theYeti.m_5448_();
        if (target == null) {
            this.theYeti.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.theYeti.targetIsFacingMe && target.m_142582_((Entity)this.theYeti);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.theYeti.m_217043_().m_188500_() < 0.1) {
                this.theYeti.disappear();
            } else if (this.theYeti.m_217043_().m_188500_() < 0.3) {
                this.theYeti.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.theYeti.pleaseStopMoving = false;
            this.theYeti.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.theYeti.pleaseStopMoving = true;
            this.theYeti.m_21573_().m_26573_();
            this.theYeti.m_20256_(Vec3.f_82478_);
        }
        this.theYeti.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

