/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.the_origin.util;

import de.cadentem.the_origin.TheOrigin;
import de.cadentem.the_origin.config.ServerConfig;
import de.cadentem.the_origin.entities.TheOriginEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Utils.secondsToTicks(minutes * 60);
    }

    public static String getTextureAppend() {
        return "";
    }

    public static boolean isValidTarget(Entity entity) {
        Player player;
        if (entity == null) {
            return false;
        }
        if (!entity.m_6084_()) {
            return false;
        }
        if (!((Boolean)ServerConfig.TARGET_INVISIBLE.get()).booleanValue() && entity.m_20145_()) {
            return false;
        }
        return !(entity instanceof Player) || !(player = (Player)entity).m_7500_() && !player.m_5833_();
    }

    public static LivingEntity getValidTarget(@NotNull TheOriginEntity theOrigin) {
        return theOrigin.f_19853_.m_5788_(theOrigin.m_20182_().f_82479_, theOrigin.m_20182_().f_82480_, theOrigin.m_20182_().f_82481_, 128.0, Utils::isValidTarget);
    }

    public static boolean isOnSurface(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPosition = entity.m_20183_();
            if (serverLevel.m_45527_(blockPosition)) {
                return true;
            }
            Holder biome = serverLevel.m_204166_(blockPosition);
            if (biome.m_203656_(Tags.Biomes.IS_CAVE) || biome.m_203656_(Tags.Biomes.IS_UNDERGROUND)) {
                return false;
            }
            int baseSkyLightLevel = serverLevel.m_45517_(LightLayer.SKY, blockPosition) - serverLevel.m_7445_();
            if (baseSkyLightLevel > 0) {
                return true;
            }
        }
        return false;
    }

    public static <T extends Mob> Optional<T> trySpawnMob(@NotNull Entity currentVictim, EntityType<T> entityType, MobSpawnType spawnType, ServerLevel level, BlockPos blockPosition, int attempts, int xzOffset, int yOffset, SpawnUtil.Strategy strategy) {
        BlockPos.MutableBlockPos mutableBlockPosition = blockPosition.m_122032_();
        for (int i = 0; i < attempts; ++i) {
            Mob entity;
            int xOffset = Mth.m_216287_((RandomSource)level.f_46441_, (int)(-xzOffset), (int)xzOffset);
            int zOffset = Mth.m_216287_((RandomSource)level.f_46441_, (int)(-xzOffset), (int)xzOffset);
            mutableBlockPosition.m_122154_((Vec3i)blockPosition, xOffset, yOffset, zOffset);
            if (!level.m_6857_().m_61937_((BlockPos)mutableBlockPosition) || !SpawnUtil.m_216398_((ServerLevel)level, (int)yOffset, (BlockPos.MutableBlockPos)mutableBlockPosition, (SpawnUtil.Strategy)strategy) || !((entity = (Mob)entityType.m_20655_(level, null, null, null, (BlockPos)mutableBlockPosition, spawnType, false, false)) instanceof TheOriginEntity)) continue;
            if (entity.m_5545_((LevelAccessor)level, spawnType) && entity.m_6914_((LevelReader)level)) {
                boolean isValidSpawn;
                boolean bl = isValidSpawn = entity.f_19853_.m_45930_((Entity)entity, (double)((Integer)ServerConfig.SPAWN_DISTANCE.get()).intValue()) == null;
                if (isValidSpawn && ((Boolean)ServerConfig.CHECK_PATH_TO_SPAWN.get()).booleanValue()) {
                    Path path = entity.m_21573_().m_6570_(currentVictim, 0);
                    boolean bl2 = isValidSpawn = path != null && path.m_77403_();
                }
                if (isValidSpawn) {
                    entity.m_21573_().m_7864_(entity.m_20183_(), 0);
                    entity.m_21573_().m_26573_();
                    level.m_47205_((Entity)entity);
                    return Optional.of(entity);
                }
            }
            entity.m_146870_();
        }
        TheOrigin.LOG.debug("Origin could not pass the spawn checks, target: [{}]", (Object)currentVictim);
        return Optional.empty();
    }
}

