/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.the_origin.entities.goals;

import de.cadentem.the_origin.entities.TheOriginEntity;
import de.cadentem.the_origin.entities.goals.Roll;
import de.cadentem.the_origin.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class TheOriginStareGoal
extends Goal {
    private final TheOriginEntity theOrigin;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public TheOriginStareGoal(TheOriginEntity theOrigin) {
        this.theOrigin = theOrigin;
        this.lookedAtMax = theOrigin.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.theOrigin.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.theOrigin.m_5448_())) {
            return false;
        }
        return this.theOrigin.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.theOrigin.m_5448_())) {
            return false;
        }
        return this.theOrigin.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.theOrigin.pleaseStopMoving = false;
        this.theOrigin.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.theOrigin.m_5448_();
        if (target == null) {
            this.theOrigin.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.theOrigin.targetIsFacingMe && target.m_142582_((Entity)this.theOrigin);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.theOrigin.m_217043_().m_188500_() < 0.1) {
                this.theOrigin.disappear();
            } else if (this.theOrigin.m_217043_().m_188500_() < 0.3) {
                this.theOrigin.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.theOrigin.pleaseStopMoving = false;
            this.theOrigin.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.theOrigin.pleaseStopMoving = true;
            this.theOrigin.m_21573_().m_26573_();
            this.theOrigin.m_20256_(Vec3.f_82478_);
        }
        this.theOrigin.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

