/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.creation.entities.goals;

import de.cadentem.creation.entities.TheCreationEntity;
import de.cadentem.creation.entities.goals.Roll;
import de.cadentem.creation.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class TheCreationStareGoal
extends Goal {
    private final TheCreationEntity theCreation;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public TheCreationStareGoal(TheCreationEntity theCreation) {
        this.theCreation = theCreation;
        this.lookedAtMax = theCreation.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.theCreation.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.theCreation.m_5448_())) {
            return false;
        }
        return this.theCreation.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.theCreation.m_5448_())) {
            return false;
        }
        return this.theCreation.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.theCreation.pleaseStopMoving = false;
        this.theCreation.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.theCreation.m_5448_();
        if (target == null) {
            this.theCreation.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.theCreation.targetIsFacingMe && target.m_142582_((Entity)this.theCreation);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.theCreation.m_217043_().m_188500_() < 0.1) {
                this.theCreation.disappear();
            } else if (this.theCreation.m_217043_().m_188500_() < 0.3) {
                this.theCreation.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.theCreation.pleaseStopMoving = false;
            this.theCreation.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.theCreation.pleaseStopMoving = true;
            this.theCreation.m_21573_().m_26573_();
            this.theCreation.m_20256_(Vec3.f_82478_);
        }
        this.theCreation.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

