/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.corpse_stalker.entities.goals;

import de.cadentem.corpse_stalker.entities.CorpseStalkerEntity;
import de.cadentem.corpse_stalker.entities.goals.Roll;
import de.cadentem.corpse_stalker.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CorpseStalkerStareGoal
extends Goal {
    private final CorpseStalkerEntity corpseStalker;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public CorpseStalkerStareGoal(CorpseStalkerEntity corpseStalker) {
        this.corpseStalker = corpseStalker;
        this.lookedAtMax = corpseStalker.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.corpseStalker.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.corpseStalker.m_5448_())) {
            return false;
        }
        return this.corpseStalker.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.corpseStalker.m_5448_())) {
            return false;
        }
        return this.corpseStalker.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.corpseStalker.pleaseStopMoving = false;
        this.corpseStalker.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.corpseStalker.m_5448_();
        if (target == null) {
            this.corpseStalker.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.corpseStalker.targetIsFacingMe && target.m_142582_((Entity)this.corpseStalker);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.corpseStalker.m_217043_().m_188500_() < 0.1) {
                this.corpseStalker.disappear();
            } else if (this.corpseStalker.m_217043_().m_188500_() < 0.3) {
                this.corpseStalker.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.corpseStalker.pleaseStopMoving = false;
            this.corpseStalker.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.corpseStalker.pleaseStopMoving = true;
            this.corpseStalker.m_21573_().m_26573_();
            this.corpseStalker.m_20256_(Vec3.f_82478_);
        }
        this.corpseStalker.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

