/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_crawler.entities.goals;

import de.cadentem.cave_crawler.entities.CaveCrawlerEntity;
import de.cadentem.cave_crawler.entities.goals.Roll;
import de.cadentem.cave_crawler.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CaveCrawlerStareGoal
extends Goal {
    private final CaveCrawlerEntity caveCrawler;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public CaveCrawlerStareGoal(CaveCrawlerEntity caveCrawler) {
        this.caveCrawler = caveCrawler;
        this.lookedAtMax = caveCrawler.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.caveCrawler.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.caveCrawler.m_5448_())) {
            return false;
        }
        return this.caveCrawler.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.caveCrawler.m_5448_())) {
            return false;
        }
        return this.caveCrawler.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.caveCrawler.pleaseStopMoving = false;
        this.caveCrawler.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.caveCrawler.m_5448_();
        if (target == null) {
            this.caveCrawler.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.caveCrawler.targetIsFacingMe && target.m_142582_((Entity)this.caveCrawler);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.caveCrawler.m_217043_().m_188500_() < 0.1) {
                this.caveCrawler.disappear();
            } else if (this.caveCrawler.m_217043_().m_188500_() < 0.3) {
                this.caveCrawler.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.caveCrawler.pleaseStopMoving = false;
            this.caveCrawler.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.caveCrawler.pleaseStopMoving = true;
            this.caveCrawler.m_21573_().m_26573_();
            this.caveCrawler.m_20256_(Vec3.f_82478_);
        }
        this.caveCrawler.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

