/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_crawler.entities.goals;

import de.cadentem.cave_crawler.entities.CaveCrawlerEntity;
import de.cadentem.cave_crawler.entities.goals.Roll;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class CaveCrawlerFleeGoal
extends Goal {
    private final CaveCrawlerEntity caveCrawler;
    private final double speedModifier;
    private float ticksUntilLeave;
    private float ticksUntilFlee;
    private boolean shouldLeave;
    private Path fleePath;
    private int ticksUntilNextPathRecalculation;

    public CaveCrawlerFleeGoal(CaveCrawlerEntity caveCrawler, float ticksUntilLeave, double speedModifier) {
        this.caveCrawler = caveCrawler;
        this.ticksUntilLeave = ticksUntilLeave;
        this.ticksUntilFlee = 10.0f;
        this.speedModifier = speedModifier;
    }

    public boolean m_8036_() {
        if (this.caveCrawler.m_20145_()) {
            return false;
        }
        if (this.caveCrawler.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.caveCrawler.m_5448_() != null;
    }

    public boolean m_8045_() {
        if (this.caveCrawler.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.caveCrawler.m_5448_() != null;
    }

    public void m_8056_() {
        this.setFleePath();
        this.shouldLeave = false;
    }

    public void m_8037_() {
        LivingEntity target = this.caveCrawler.m_5448_();
        if (this.shouldLeave && !this.caveCrawler.targetIsFacingMe) {
            this.caveCrawler.disappear();
        }
        this.ticksUntilFlee -= 1.0f;
        this.tickStareClock();
        if (this.ticksUntilFlee <= 0.0f) {
            this.fleeTick();
            this.caveCrawler.isFleeing = true;
            this.caveCrawler.m_20088_().m_135381_(CaveCrawlerEntity.FLEEING_ACCESSOR, (Object)true);
        } else if (target != null) {
            this.caveCrawler.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
        }
    }

    private void setFleePath() {
        LivingEntity target = this.caveCrawler.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 fleePosition = DefaultRandomPos.m_148407_((PathfinderMob)this.caveCrawler, (int)32, (int)7, (Vec3)target.m_20182_());
        if (fleePosition != null) {
            this.fleePath = this.caveCrawler.m_21573_().m_26524_(fleePosition.f_82479_, fleePosition.f_82480_, fleePosition.f_82481_, 0);
        }
    }

    public void tickStareClock() {
        this.ticksUntilLeave -= 1.0f;
        if (this.ticksUntilLeave < 0.0f) {
            this.shouldLeave = true;
        }
    }

    public void fleeTick() {
        if (this.fleePath == null || this.fleePath.m_77392_()) {
            this.setFleePath();
        }
        this.caveCrawler.playFleeSound();
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (this.ticksUntilNextPathRecalculation == 0) {
            this.ticksUntilNextPathRecalculation = 2;
            if (!this.caveCrawler.m_21573_().m_26536_(this.fleePath, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 2;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
    }
}

