/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.goatman.entities.goals;

import de.cadentem.goatman.entities.GoatmanEntity;
import de.cadentem.goatman.entities.goals.Roll;
import de.cadentem.goatman.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GoatmanStareGoal
extends Goal {
    private final GoatmanEntity goatMan;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public GoatmanStareGoal(GoatmanEntity goatMan) {
        this.goatMan = goatMan;
        this.lookedAtMax = goatMan.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.goatMan.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.goatMan.m_5448_())) {
            return false;
        }
        return this.goatMan.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.goatMan.m_5448_())) {
            return false;
        }
        return this.goatMan.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.goatMan.pleaseStopMoving = false;
        this.goatMan.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.goatMan.m_5448_();
        if (target == null) {
            this.goatMan.vanish();
            return;
        }
        boolean bl = actuallyLooking = this.goatMan.targetIsFacingMe && target.m_142582_((Entity)this.goatMan);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.goatMan.m_217043_().m_188500_() < 0.1) {
                this.goatMan.vanish();
            } else if (this.goatMan.m_217043_().m_188500_() < 0.3) {
                this.goatMan.pickRoll(List.of(Roll.SCREAM, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.goatMan.pleaseStopMoving = false;
            this.goatMan.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.goatMan.pleaseStopMoving = true;
            this.goatMan.m_21573_().m_26573_();
            this.goatMan.m_20256_(Vec3.f_82478_);
        }
        this.goatMan.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

