/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.goatman.entities.goals;

import de.cadentem.goatman.entities.GoatmanEntity;
import de.cadentem.goatman.entities.goals.Roll;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class GoatmanFleeGoal
extends Goal {
    private final GoatmanEntity goatMan;
    private final double speedModifier;
    private float ticksUntilLeave;
    private float ticksUntilFlee;
    private boolean shouldLeave;
    private Path fleePath;
    private int ticksUntilNextPathRecalculation;

    public GoatmanFleeGoal(GoatmanEntity goatMan, float ticksUntilLeave, double speedModifier) {
        this.goatMan = goatMan;
        this.ticksUntilLeave = ticksUntilLeave;
        this.ticksUntilFlee = 10.0f;
        this.speedModifier = speedModifier;
    }

    public boolean m_8036_() {
        if (this.goatMan.m_20145_()) {
            return false;
        }
        if (this.goatMan.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.goatMan.m_5448_() != null;
    }

    public boolean m_8045_() {
        if (this.goatMan.currentRoll != Roll.FLEE) {
            return false;
        }
        return this.goatMan.m_5448_() != null;
    }

    public void m_8056_() {
        this.setFleePath();
        this.shouldLeave = false;
    }

    public void m_8037_() {
        LivingEntity target = this.goatMan.m_5448_();
        if (this.shouldLeave && !this.goatMan.targetIsFacingMe) {
            this.goatMan.vanish();
        }
        this.ticksUntilFlee -= 1.0f;
        this.tickStareClock();
        if (this.ticksUntilFlee <= 0.0f) {
            this.fleeTick();
            this.goatMan.isFleeing = true;
            this.goatMan.m_20088_().m_135381_(GoatmanEntity.FLEEING_ACCESSOR, (Object)true);
        } else if (target != null) {
            this.goatMan.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
        }
    }

    private void setFleePath() {
        LivingEntity target = this.goatMan.m_5448_();
        if (target == null) {
            return;
        }
        Vec3 fleePosition = DefaultRandomPos.m_148407_((PathfinderMob)this.goatMan, (int)32, (int)7, (Vec3)target.m_20182_());
        if (fleePosition != null) {
            this.fleePath = this.goatMan.m_21573_().m_26524_(fleePosition.f_82479_, fleePosition.f_82480_, fleePosition.f_82481_, 0);
        }
    }

    public void tickStareClock() {
        this.ticksUntilLeave -= 1.0f;
        if (this.ticksUntilLeave < 0.0f) {
            this.shouldLeave = true;
        }
    }

    public void fleeTick() {
        if (this.fleePath == null || this.fleePath.m_77392_()) {
            this.setFleePath();
        }
        this.goatMan.playFleeSound();
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (this.ticksUntilNextPathRecalculation == 0) {
            this.ticksUntilNextPathRecalculation = 2;
            if (!this.goatMan.m_21573_().m_26536_(this.fleePath, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 2;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
    }
}

